class node {

  String name;
  String defaultLink;
  String soundPath;
  String imagePath;
  String caption;
  String[] imageTags;
  String[] soundTags;
  link[] links = new link[0];

  AudioPlayer sound;
  String transitionIn;
  String transitionOut;

  node(String nodeName, 
  String nodeDefaultLink, 
  String nodeImagePath, 
  String nodeSoundPath, 
  String nodeCaption, 
  String[] nodeImageTags, 
  String[] nodeSoundTags, 
  link[] nodeLinks) {

    name = nodeName;
    defaultLink = nodeDefaultLink;
    imagePath = nodeImagePath;
    soundPath = nodeSoundPath;
    caption = nodeCaption;
    soundTags = nodeSoundTags;
    imageTags = nodeImageTags;

    for (link l : nodeLinks) {
      links = (link[]) append(links, l);
    }

    if (Arrays.asList(nodeImageTags).contains("fadeIn")) transitionIn = "fadeIn";
  }

  PImage load_picture() {
    PImage picture = loadImage(resourceDirectory+"/"+name+"/"+imagePath);
    return picture;
  }

  AudioPlayer load_sound() {
    if (sound != null && sound.isPlaying()) sound.close();
    sound = minim.loadFile(resourceDirectory+"/"+name+"/"+soundPath);
    if (Arrays.asList(soundTags).contains("loop")) sound.loop();  
    return sound;
  }

  void new_link() {
    String to = JOptionPane.showInputDialog(null, "links to", name, 1);
    if (to != null) links = (link[]) append(links, new link(to, 10, 10, 20, 20));
    calculate_link_positions();
  }
}

